def solve():
    data = []
    
    try:
        while True:
            line = input()
            if not line:
                break
            data.extend(line.split())
    except EOFError:
        pass
    except Exception:
        return

    if not data:
        return

    iterator = iter(data)
    
    try:
        N = int(next(iterator))
        epsilon = float(next(iterator))
        
        points = []
        for i in range(N):
            x = float(next(iterator))
            y = float(next(iterator))
            points.append((x, y, i + 1))
    except (StopIteration, ValueError):
        return
    except Exception:
        return

    if N == 0:
        print(0)
        return

    delta = epsilon / 2.0
    
    Q_map = {}
    
    for x, y, original_index in points:
        i_grid = int(x / delta)
        j_grid = int(y / delta)
        
        if i_grid * delta == 1.0 and i_grid > 0:
            i_grid -= 1
        if j_grid * delta == 1.0 and j_grid > 0:
            j_grid -= 1
            
        cell = (i_grid, j_grid)
        
        if cell not in Q_map:
            Q_map[cell] = (x, y, original_index)

    Q_list = list(Q_map.values())
    size_Q = len(Q_list)
    
    if size_Q <= 1:
        print(size_Q)
        if size_Q == 1:
            print(Q_list[0][2])
        return

    edges = []
    
    Q_map_index = {}
    for i, (_, _, original_index) in enumerate(Q_list):
        Q_map_index[original_index] = i
        
    for i in range(size_Q):
        xi, yi, index_i = Q_list[i]
        for j in range(i + 1, size_Q):
            xj, yj, index_j = Q_list[j]
            
            weight = abs(xi - xj) + abs(yi - yj)
            
            edges.append((weight, index_i, index_j))

    edges.sort()
    
    parent = list(range(size_Q))
    
    def find(i):
        if parent[i] == i:
            return i
        path = []
        root = i
        while parent[root] != root:
            path.append(root)
            root = parent[root]
        for node in path:
            parent[node] = root
        return root

    def union(i, j):
        root_i = find(i)
        root_j = find(j)
        if root_i != root_j:
            parent[root_i] = root_j
            return True
        return False

    MST_edges = []
    
    for _, index_i, index_j in edges:
        u = Q_map_index[index_i]
        v = Q_map_index[index_j]
        
        if union(u, v):
            MST_edges.append((index_i, index_j))
            if len(MST_edges) == size_Q - 1:
                break
                

    
    print(size_Q)
    
    indices_Q = [p[2] for p in Q_list]
    print(*(indices_Q))
    
    for u, v in MST_edges:
        print(f"{u} {v}")

if __name__ == '__main__':
    solve()